dofile('Scripts/Database/Weapons/weapon_utils.lua')

local namehe = 'MAM L HE'
local nameheat = 'MAM L HEAT'
local mass = 22

local dCydA01 = calcCy(500 * 1.85 / 3.6, 0, 22, 2.8, 0.5) / math.deg(math.rad(7))




local maml_he = 
{
     mass			 		= 22,
     expl_mass        		= 18,
     other_factors    		= { 1.0, 1.0, 1.0 },
     concrete_factors 		= { 1.0, 1.0, 0.1 },
     concrete_obj_factor 	= 0.0,
     obj_factors      	 	= {0.08, 1.0 },
     cumulative_factor		= 0.22,
     cumulative_thickness   = 0.22,
	 piercing_mass          = 4.40
	
}

local maml_heat = 
{
     mass        	  = 22,
	 expl_mass        = 18,
     other_factors    = { 1.0, 0.5, 0.5 },
     concrete_factors = { 1.0, 0.5, 0.1 },
     concrete_obj_factor = 0.0,
     obj_factors      = { 1.0, 1.0 },
     cumulative_factor= 1.2,
     cumulative_thickness = 0.3,
	 piercing_mass        = 4.40
	
}


MAM_L_HE = {

    category       = CAT_BOMBS,
    name           = namehe,
    user_name      = _(namehe),
    wsTypeOfWeapon = {4, 5, 36, WSTYPE_PLACEHOLDER},
    model          = "MAM_L_HE",
    scheme         = "bomb-paveway-II-afm",
    class_name     = 'wAmmunitionLaserHoming',
    
    shape_table_data = {
	
        {
            name     = namehe,
            file     = 'MAM_L_HE',
            life     = 1,
            fire     = { 0, 1},
            username = namehe,
            index    = WSTYPE_PLACEHOLDER,
        },
    },
	
	-- bomb data 
    type        = 4,
    mass        = 22,
    hMin        = 50.0,
    hMax        = 3000.0,
    Cx          = 0.00025,
    VyHold      = -50.0,
    Ag          = -20.0,
    warhead     = maml_he,
    --sounderName = 'Weapons/BetAB_500ShP',
	LaunchDistData =
		{
			19,		8,

					100,	150,	200,	250,	300,	350,	400,	450,		
			100,	0,		0,		3000,	5550,	7575,	8375,	8975,	9025,	
			200,	0,		0,		3625,	6350,	8400,	9750,	10425,	11100,	
			400,	0,		0,		4325,	7200,	9175,	10525,	11450,	12250,	
			700,	0,		0,		5500,	8325,	10325,	11600,	12500,	13275,	
			1000,	0,		0,		6600,	9400,	11400,	12600,	13550,	14300,	
			2000,	2450,	7000,	10450,	13150,	14950,	16150,	17000,	17750,	
			3000,	4800,	10900,	14300,	16900,	18600,	19700,	20400,	21200,	
			4000,	6100,	14400,	18100,	20800,	22300,	23300,	24100,	24800,	
			5000,	7100,	17200,	21900,	24600,	26200,	27100,	27800,	28500,	
			6000,	8100,	17200,	25500,	28600,	30000,	30900,	31600,	32400,	
			7000,	8750,	17250,	28750,	32500,	33750,	34750,	35500,	36000,	
			8000,	9500,	17500,	32250,	36250,	37750,	38500,	39250,	40250,	
			9000,	10250,	17750,	35250,	39500,	41750,	42500,	43250,	44250,	
			10000,	10750,	18000,	38000,	42500,	45500,	46500,	47250,	48250,	
			11000,	11000,	18000,	39500,	45000,	48500,	50500,	51000,	52500,	
			12000,	11500,	18000,	34500,	47000,	51500,	54000,	55000,	56500,	
			13000,	11000,	18000,	31000,	49000,	53000,	57000,	59000,	60000,	
			14000,	12000,	18000,	29000,	51000,	55000,	59000,	63000,	64000,	
			15000,	12000,	18000,	28000,	48000,	57000,	61000,	66000,	68000,	
		},

		MinLaunchDistData =
		{
			19,		8,

					100,	150,	200,	250,	300,	350,	400,	450,		
			100,	0,		0,		1225,	1475,	1125,	1125,	700,	1100,	
			200,	0,		0,		1725,	1050,	1075,	1100,	1225,	1100,	
			400,	0,		0,		1800,	1825,	1825,	1825,	1825,	1825,	
			700,	0,		0,		2725,	3050,	3175,	3175,	3175,	3175,	
			1000,	0,		0,		3350,	4000,	4400,	4550,	4550,	4550,	
			2000,	2150,	3450,	4700,	5800,	6700,	7450,	8150,	8800,	
			3000,	2500,	4100,	5600,	7000,	8100,	9200,	10100,	11100,	
			4000,	2700,	4500,	6200,	7800,	9200,	10400,	11500,	12700,	
			5000,	2900,	4800,	6800,	8500,	10100,	11400,	12700,	14100,	
			6000,	3100,	5100,	7200,	9100,	10800,	12200,	13700,	15300,	
			7000,	3250,	5500,	7750,	9750,	11500,	13000,	14750,	16500,	
			8000,	3500,	5750,	7750,	10000,	12000,	13750,	15500,	17500,	
			9000,	3500,	6000,	8250,	10500,	12500,	14500,	16250,	18750,	
			10000,	3500,	6000,	8500,	11000,	13000,	15000,	17250,	19750,	
			11000,	3500,	6500,	9000,	11500,	13500,	15500,	18000,	21000,	
			12000,	3500,	6500,	9000,	11500,	14000,	16500,	19000,	22000,	
			13000,	4000,	7000,	10000,	12000,	15000,	17000,	20000,	23000,	
			14000,	4000,	7000,	10000,	13000,	14000,	18000,	21000,	24000,	
			15000,	4000,	7000,	10000,	13000,	16000,	19000,	22000,	25000,	
		},
		
		--scheme data 
		
		 fm =
    {
            mass            = 22.0,
            caliber         = 0.160000,
            cx_coeff        = {1.037, 0.74, 0.6, 0.382, 1.34},
            L               = 1.00000,
            wind_time       = 1000.000000,
            wind_sigma      = 0 * 80.000000,
			Sw				= 0.8,
			dCydA           = {dCydA01, 0.036},
			A				= 0.36,
			Ma_x			= 0.1,
			Mw_x			= 1.0,
			maxAoa			= math.rad(7),
			finsTau			= 0.1
    },
	
	bang_bang_autopilot = {
		omegaDumpingK = 0.8
	},
	
	warhead     = maml_he,
	
	targeting_data =
	{
    char_time       = 20.380000
    },

}

declare_weapon(MAM_L_HE)


MAM_L_HEAT = {

    category       = CAT_BOMBS,
    name           = nameheat,
    user_name      = _(nameheat),
    wsTypeOfWeapon = {4, 5, 36, WSTYPE_PLACEHOLDER},
    
    model          = "MAM_L_HEAT",
    scheme         = "bomb-paveway-II-afm",
    class_name     = 'wAmmunitionLaserHoming',
    
    shape_table_data = {
	
        {
            name     = nameheat,
            file     = 'MAM_L_HEAT',
            life     = 1,
            fire     = { 0, 1},
            username = nameheat,
            index    = WSTYPE_PLACEHOLDER,
        },
    },
	
	-- bomb data 
    type        = 4,
    mass        = 22,
    hMin        = 50.0,
    hMax        = 3000.0,
    Cx          = 0.00025,
    VyHold      = -50.0,
    Ag          = -20.0,
    warhead     = maml_heat,
    --sounderName = 'Weapons/BetAB_500ShP',
	
	
	LaunchDistData =
		{
			19,		8,

					100,	150,	200,	250,	300,	350,	400,	450,		
			100,	0,		0,		3000,	5550,	7575,	8375,	8975,	9025,	
			200,	0,		0,		3625,	6350,	8400,	9750,	10425,	11100,	
			400,	0,		0,		4325,	7200,	9175,	10525,	11450,	12250,	
			700,	0,		0,		5500,	8325,	10325,	11600,	12500,	13275,	
			1000,	0,		0,		6600,	9400,	11400,	12600,	13550,	14300,	
			2000,	2450,	7000,	10450,	13150,	14950,	16150,	17000,	17750,	
			3000,	4800,	10900,	14300,	16900,	18600,	19700,	20400,	21200,	
			4000,	6100,	14400,	18100,	20800,	22300,	23300,	24100,	24800,	
			5000,	7100,	17200,	21900,	24600,	26200,	27100,	27800,	28500,	
			6000,	8100,	17200,	25500,	28600,	30000,	30900,	31600,	32400,	
			7000,	8750,	17250,	28750,	32500,	33750,	34750,	35500,	36000,	
			8000,	9500,	17500,	32250,	36250,	37750,	38500,	39250,	40250,	
			9000,	10250,	17750,	35250,	39500,	41750,	42500,	43250,	44250,	
			10000,	10750,	18000,	38000,	42500,	45500,	46500,	47250,	48250,	
			11000,	11000,	18000,	39500,	45000,	48500,	50500,	51000,	52500,	
			12000,	11500,	18000,	34500,	47000,	51500,	54000,	55000,	56500,	
			13000,	11000,	18000,	31000,	49000,	53000,	57000,	59000,	60000,	
			14000,	12000,	18000,	29000,	51000,	55000,	59000,	63000,	64000,	
			15000,	12000,	18000,	28000,	48000,	57000,	61000,	66000,	68000,	
		},

		MinLaunchDistData =
		{
			19,		8,

					100,	150,	200,	250,	300,	350,	400,	450,		
			100,	0,		0,		1225,	1475,	1125,	1125,	700,	1100,	
			200,	0,		0,		1725,	1050,	1075,	1100,	1225,	1100,	
			400,	0,		0,		1800,	1825,	1825,	1825,	1825,	1825,	
			700,	0,		0,		2725,	3050,	3175,	3175,	3175,	3175,	
			1000,	0,		0,		3350,	4000,	4400,	4550,	4550,	4550,	
			2000,	2150,	3450,	4700,	5800,	6700,	7450,	8150,	8800,	
			3000,	2500,	4100,	5600,	7000,	8100,	9200,	10100,	11100,	
			4000,	2700,	4500,	6200,	7800,	9200,	10400,	11500,	12700,	
			5000,	2900,	4800,	6800,	8500,	10100,	11400,	12700,	14100,	
			6000,	3100,	5100,	7200,	9100,	10800,	12200,	13700,	15300,	
			7000,	3250,	5500,	7750,	9750,	11500,	13000,	14750,	16500,	
			8000,	3500,	5750,	7750,	10000,	12000,	13750,	15500,	17500,	
			9000,	3500,	6000,	8250,	10500,	12500,	14500,	16250,	18750,	
			10000,	3500,	6000,	8500,	11000,	13000,	15000,	17250,	19750,	
			11000,	3500,	6500,	9000,	11500,	13500,	15500,	18000,	21000,	
			12000,	3500,	6500,	9000,	11500,	14000,	16500,	19000,	22000,	
			13000,	4000,	7000,	10000,	12000,	15000,	17000,	20000,	23000,	
			14000,	4000,	7000,	10000,	13000,	14000,	18000,	21000,	24000,	
			15000,	4000,	7000,	10000,	13000,	16000,	19000,	22000,	25000,	
		},
		
		--scheme data 
		
		 fm =
    {
            mass            = 22.0,
            caliber         = 0.160000,
            cx_coeff        = {1.037, 0.74, 0.6, 0.382, 1.34},
            L               = 1.00000,
            wind_time       = 1000.000000,
            wind_sigma      = 0 * 80.000000,
			Sw				= 0.8,
			dCydA           = {dCydA01, 0.036},
			A				= 0.36,
			Ma_x			= 0.1,
			Mw_x			= 1.0,
			maxAoa			= math.rad(7),
			finsTau			= 0.1
    },
	
	bang_bang_autopilot = {
		omegaDumpingK = 0.8
	},
	
	warhead     = maml_heat,
	
	targeting_data =
	{
    char_time       = 20.380000
    },

}

declare_weapon(MAM_L_HEAT)


---------------------------------Single------------------------------


declare_loadout({
    category         = CAT_BOMBS,
    CLSID            = '{maml_he}',
    attribute        = MAM_L_HE.wsTypeOfWeapon,
    Count            = 1,
    Cx_pil           = 0.0006265625,
    Picture          = "mam_l_he.png", -- TODO
    displayName      = _(namehe),
    Weight           = mass,
    Elements         = {{ShapeName = 'MAM_L_HE'}}, -- TODO
    ejectImpulse     = 140,
	
})

declare_loadout({
    category         = CAT_BOMBS,
    CLSID            = '{maml_heat}',
    attribute        = MAM_L_HEAT.wsTypeOfWeapon,
    Count            = 1,
    Cx_pil           = 0.0006265625,
    Picture          = "mam_l_heat.png", -- TODO
    displayName      = _(nameheat),
    Weight           = mass,
    Elements         = {{ShapeName = 'MAM_L_HEAT'}}, -- TODO
    ejectImpulse     = 140,
	
})

-------------------------------Dual----------------------------------------

declare_loadout({

     category         = CAT_BOMBS,
    CLSID            = '{maml_he_2L}',
    attribute        = {4,	5,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon   = MAM_L_HE.wsTypeOfWeapon,
    Count            = 2,
    Cx_pil           = 0.002,
    Picture          = "mam_l_he.png", -- TODO
    displayName      = _(namehe.." x2"),
    Weight           = 2 * mass + 150,
	Elements =
    {
        {ShapeName = "shitty_bru_wannabe",    IsAdapter      = true},
        {ShapeName = "MAM_L_HE",  connector_name = "maml001"},
        {ShapeName = "MAM_L_HE",  connector_name = "maml002"},
    },
    ejectImpulse     = 140,
	
})

declare_loadout({

    category         = CAT_BOMBS,
    CLSID            = '{maml_he_2R}',
    attribute        = {4,	5,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon   = MAM_L_HE.wsTypeOfWeapon,
    Count            = 2,
    Cx_pil           = 0.002,
    Picture          = "mam_l_he.png", -- TODO
    displayName      = _(namehe.." x2"),
    Weight           = 2 * mass + 150,
	Elements =
    {
        {ShapeName = "shitty_bru_wannabe",    IsAdapter      = true},
        {ShapeName = "MAM_L_HE",  connector_name = "maml002"},
        {ShapeName = "MAM_L_HE",  connector_name = "maml001"},
    },
    ejectImpulse     = 140,
	
})


declare_loadout({

     category         = CAT_BOMBS,
    CLSID            = '{maml_heat_2L}',
    attribute        = {4,	5,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon   = MAM_L_HEAT.wsTypeOfWeapon,
    Count            = 2,
    Cx_pil           = 0.002,
    Picture          = "mam_l_heat.png", -- TODO
    displayName      = _(nameheat.." x2"),
    Weight           = 2 * mass + 150,
	Elements =
    {
        {ShapeName = "shitty_bru_wannabe",    IsAdapter      = true},
        {ShapeName = "MAM_L_HEAT",  connector_name = "maml001"},
        {ShapeName = "MAM_L_HEAT",  connector_name = "maml002"},
    },
    ejectImpulse     = 140,
	
})

declare_loadout({

    category         = CAT_BOMBS,
    CLSID            = '{maml_heat_2R}',
    attribute        = {4,	5,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon   = MAM_L_HEAT.wsTypeOfWeapon,
    Count            = 2,
    Cx_pil           = 0.002,
    Picture          = "mam_l_heat.png", -- TODO
    displayName      = _(nameheat.." x2"),
    Weight           = 2 * mass + 150,
	Elements =
    {
        {ShapeName = "shitty_bru_wannabe",    IsAdapter      = true},
        {ShapeName = "MAM_L_HEAT",  connector_name = "maml002"},
        {ShapeName = "MAM_L_HEAT",  connector_name = "maml001"},
    },
    ejectImpulse     = 140,
	
})

-------------------------------Quad----------------------------------------

declare_loadout({

     category         = CAT_BOMBS,
    CLSID            = '{maml_he_4L}',
    attribute        = {4,	5,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon   = MAM_L_HE.wsTypeOfWeapon,
    Count            = 4,
    Cx_pil           = 0.002,
    Picture          = "mam_l_he.png", -- TODO
    displayName      = _(namehe.." x4"),
    Weight           = 4 * mass + 150,
	Elements =
    {
        {ShapeName = "shitty_bru_wannabe",    IsAdapter      = true},
        {ShapeName = "MAM_L_HE",  connector_name = "maml001"},
        {ShapeName = "MAM_L_HE",  connector_name = "maml002"},
		{ShapeName = "MAM_L_HE",  connector_name = "maml003"},
        {ShapeName = "MAM_L_HE",  connector_name = "maml004"},
    },
    ejectImpulse     = 140,
	
})

declare_loadout({

    category         = CAT_BOMBS,
    CLSID            = '{maml_he_4R}',
    attribute        = {4,	5,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon   = MAM_L_HE.wsTypeOfWeapon,
    Count            = 4,
    Cx_pil           = 0.002,
    Picture          = "mam_l_he.png", -- TODO
    displayName      = _(namehe.." x4"),
    Weight           = 4 * mass + 150,
	Elements =
    {
        {ShapeName = "shitty_bru_wannabe",    IsAdapter      = true},
        {ShapeName = "MAM_L_HE",  connector_name = "maml002"},
        {ShapeName = "MAM_L_HE",  connector_name = "maml001"},
		{ShapeName = "MAM_L_HE",  connector_name = "maml004"},
        {ShapeName = "MAM_L_HE",  connector_name = "maml003"},
    },
    ejectImpulse     = 140,
	
})

declare_loadout({

     category         = CAT_BOMBS,
    CLSID            = '{maml_heat_4L}',
    attribute        = {4,	5,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon   = MAM_L_HEAT.wsTypeOfWeapon,
    Count            = 4,
    Cx_pil           = 0.002,
    Picture          = "mam_l_heat.png", -- TODO
    displayName      = _(nameheat.." x4"),
    Weight           = 4 * mass + 150,
	Elements =
    {
        {ShapeName = "shitty_bru_wannabe",    IsAdapter      = true},
        {ShapeName = "MAM_L_HEAT",  connector_name = "maml001"},
        {ShapeName = "MAM_L_HEAT",  connector_name = "maml002"},
		{ShapeName = "MAM_L_HEAT",  connector_name = "maml003"},
        {ShapeName = "MAM_L_HEAT",  connector_name = "maml004"},
    },
    ejectImpulse     = 140,
	
})

declare_loadout({

    category         = CAT_BOMBS,
    CLSID            = '{maml_heat_4R}',
    attribute        = {4,	5,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon   = MAM_L_HEAT.wsTypeOfWeapon,
    Count            = 4,
    Cx_pil           = 0.002,
    Picture          = "mam_l_heat.png", -- TODO
    displayName      = _(nameheat.." x4"),
    Weight           = 4 * mass + 150,
	Elements =
    {
        {ShapeName = "shitty_bru_wannabe",    IsAdapter      = true},
        {ShapeName = "MAM_L_HEAT",  connector_name = "maml002"},
        {ShapeName = "MAM_L_HEAT",  connector_name = "maml001"},
		{ShapeName = "MAM_L_HEAT",  connector_name = "maml004"},
        {ShapeName = "MAM_L_HEAT",  connector_name = "maml003"},
    },
    ejectImpulse     = 140,
	
})

-------------------------------Hex----------------------------------------

declare_loadout({

     category         = CAT_BOMBS,
    CLSID            = '{maml_he_6L}',
    attribute        = {4,	5,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon   = MAM_L_HE.wsTypeOfWeapon,
    Count            = 6,
    Cx_pil           = 0.002,
    Picture          = "mam_l_he.png", -- TODO
    displayName      = _(namehe.." x6"),
    Weight           = 6 * mass + 150,
	Elements =
    {
        {ShapeName = "shitty_bru_wannabe",    IsAdapter      = true},
        {ShapeName = "MAM_L_HE",  connector_name = "maml001"},
        {ShapeName = "MAM_L_HE",  connector_name = "maml002"},
		{ShapeName = "MAM_L_HE",  connector_name = "maml003"},
        {ShapeName = "MAM_L_HE",  connector_name = "maml004"},
		{ShapeName = "MAM_L_HE",  connector_name = "maml005"},
        {ShapeName = "MAM_L_HE",  connector_name = "maml006"},
    },
    ejectImpulse     = 140,
	
})

declare_loadout({

    category         = CAT_BOMBS,
    CLSID            = '{maml_he_6R}',
    attribute        = {4,	5,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon   = MAM_L_HE.wsTypeOfWeapon,
    Count            = 6,
    Cx_pil           = 0.002,
    Picture          = "mam_l_he.png", -- TODO
    displayName      = _(namehe.." x6"),
    Weight           = 6 * mass + 150,
	Elements =
    {
        {ShapeName = "shitty_bru_wannabe",    IsAdapter      = true},
        {ShapeName = "MAM_L_HE",  connector_name = "maml002"},
        {ShapeName = "MAM_L_HE",  connector_name = "maml001"},
		{ShapeName = "MAM_L_HE",  connector_name = "maml004"},
        {ShapeName = "MAM_L_HE",  connector_name = "maml003"},
		{ShapeName = "MAM_L_HE",  connector_name = "maml006"},
        {ShapeName = "MAM_L_HE",  connector_name = "maml005"},
    },
    ejectImpulse     = 140,
	
})


declare_loadout({

     category         = CAT_BOMBS,
    CLSID            = '{maml_heat_6L}',
    attribute        = {4,	5,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon   = MAM_L_HEAT.wsTypeOfWeapon,
    Count            = 6,
    Cx_pil           = 0.002,
    Picture          = "mam_l_heat.png", -- TODO
    displayName      = _(nameheat.." x6"),
    Weight           = 6 * mass + 150,
	Elements =
    {
        {ShapeName = "shitty_bru_wannabe",    IsAdapter      = true},
        {ShapeName = "MAM_L_HEAT",  connector_name = "maml001"},
        {ShapeName = "MAM_L_HEAT",  connector_name = "maml002"},
		{ShapeName = "MAM_L_HEAT",  connector_name = "maml003"},
        {ShapeName = "MAM_L_HEAT",  connector_name = "maml004"},
		{ShapeName = "MAM_L_HEAT",  connector_name = "maml005"},
        {ShapeName = "MAM_L_HEAT",  connector_name = "maml006"},
    },
    ejectImpulse     = 140,
	
})

declare_loadout({

    category         = CAT_BOMBS,
    CLSID            = '{maml_heat_6R}',
    attribute        = {4,	5,	32,	WSTYPE_PLACEHOLDER},
	wsTypeOfWeapon   = MAM_L_HEAT.wsTypeOfWeapon,
    Count            = 6,
    Cx_pil           = 0.002,
    Picture          = "mam_l_heat.png", -- TODO
    displayName      = _(nameheat.." x6"),
    Weight           = 6 * mass + 150,
	Elements =
    {
        {ShapeName = "shitty_bru_wannabe",    IsAdapter      = true},
        {ShapeName = "MAM_L_HEAT",  connector_name = "maml002"},
        {ShapeName = "MAM_L_HEAT",  connector_name = "maml001"},
		{ShapeName = "MAM_L_HEAT",  connector_name = "maml004"},
        {ShapeName = "MAM_L_HEAT",  connector_name = "maml003"},
		{ShapeName = "MAM_L_HEAT",  connector_name = "maml006"},
        {ShapeName = "MAM_L_HEAT",  connector_name = "maml005"},
    },
    ejectImpulse     = 140,
	
})



---------------------------------------------






